/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.screen.ValkyrieQueenDialogueScreen;
import com.aetherteam.aether.data.resources.registries.AetherStructures;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.NpcDialogue;
import com.aetherteam.aether.entity.ai.goal.NpcDialogueGoal;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.projectile.crystal.ThunderCrystal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.packet.clientbound.BossInfoPacket;
import com.aetherteam.aether.network.packet.clientbound.QueenDialoguePacket;
import com.aetherteam.aetherfabric.entity.IEntityWithComplexSpawn;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3414;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_437;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5195;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ValkyrieQueen
extends AbstractValkyrie
implements AetherBossMob<ValkyrieQueen>,
NpcDialogue,
IEntityWithComplexSpawn {
    private static final class_2940<Boolean> DATA_IS_READY = class_2945.method_12791(ValkyrieQueen.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2561> DATA_BOSS_NAME = class_2945.method_12791(ValkyrieQueen.class, (class_2941)class_2943.field_13317);
    private static final class_5195 VALKYRIE_QUEEN_MUSIC = new class_5195(AetherSoundEvents.MUSIC_BOSS_VALKYRIE_QUEEN, 0, 0, true);
    public static final Map<class_2248, Function<class_2680, class_2680>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<class_2248, Function<class_2680, class_2680>>(Map.ofEntries(Map.entry((class_2248)AetherBlocks.LOCKED_ANGELIC_STONE.get(), blockState -> ((class_2248)AetherBlocks.ANGELIC_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.TRAPPED_ANGELIC_STONE.get(), blockState -> ((class_2248)AetherBlocks.ANGELIC_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.LOCKED_LIGHT_ANGELIC_STONE.get(), blockState -> ((class_2248)AetherBlocks.LIGHT_ANGELIC_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.TRAPPED_LIGHT_ANGELIC_STONE.get(), blockState -> ((class_2248)AetherBlocks.LIGHT_ANGELIC_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.BOSS_DOORWAY_ANGELIC_STONE.get(), blockState -> class_2246.field_10124.method_9564()), Map.entry((class_2248)AetherBlocks.TREASURE_DOORWAY_ANGELIC_STONE.get(), blockState -> (class_2680)((class_2533)AetherBlocks.SKYROOT_TRAPDOOR.get()).method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2383.field_11177))))));
    private final class_3213 bossFight = (class_3213)new class_3213(this.getBossName(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5410(true);
    @Nullable
    private BossRoomTracker<ValkyrieQueen> dungeon;
    @Nullable
    private class_238 dungeonBounds;
    @Nullable
    private class_1657 conversingPlayer;

    public ValkyrieQueen(class_1299<? extends ValkyrieQueen> type, class_1937 level) {
        super(type, level);
        this.setBossFight(false);
        this.field_6194 = 50;
        this.method_5971();
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.setBossName((class_2561)BossNameGenerator.generateValkyrieName(this.method_59922()));
        if (reason == class_3730.field_16474) {
            class_5138 manager = level.method_8410().method_27056();
            manager.method_41036().method_33310(class_7924.field_41246).ifPresent(registry -> {
                class_3449 start;
                class_3195 temple = (class_3195)registry.method_29107(AetherStructures.SILVER_DUNGEON);
                if (temple != null && (start = manager.method_28388(this.method_24515(), temple)) != class_3449.field_16713) {
                    class_3341 box = start.method_14969();
                    class_238 dungeonBounds = new class_238((double)box.method_35415(), (double)box.method_35416(), (double)box.method_35417(), (double)(box.method_35418() + 1), (double)(box.method_35419() + 1), (double)(box.method_35420() + 1));
                    this.setDungeonBounds(dungeonBounds);
                }
            });
        }
        return spawnData;
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new NpcDialogueGoal<ValkyrieQueen>(this));
        this.field_6201.method_6277(1, (class_1352)new GetUnstuckGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ThunderCrystalAttackGoal((class_1308)this, 450, 28.0f));
        this.field_6201.method_6277(3, (class_1352)new AbstractValkyrie.LungeGoal(this, 0.65, 0));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, livingEntity -> this.isBossFight()));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return AbstractValkyrie.createAttributes().method_26868(class_5134.field_23717, 28.0).method_26868(class_5134.field_23721, 13.5).method_26868(class_5134.field_23716, 500.0);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_READY, (Object)false);
        builder.method_56912(DATA_BOSS_NAME, (Object)class_2561.method_43470((String)"Valkyrie Queen"));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.breakBlocks();
        this.evaporate();
        double motionY = this.method_18798().method_10214();
        if (!this.method_24828() && Math.abs(motionY - this.lastMotionY) > 0.07 && Math.abs(motionY - this.lastMotionY) < 0.09) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.055, 0.0));
        }
    }

    private void breakBlocks() {
        class_1309 target = this.method_5968();
        if (!this.method_37908().method_8608() && target != null && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (int i = 0; i < 2; ++i) {
                class_2382 vector = i == 0 ? this.method_5755().method_10163() : class_2382.field_11176;
                class_2338 upperPosition = class_2338.method_49638((class_2374)this.method_33571()).method_10081(vector);
                class_2338 lowerPosition = this.method_24515().method_10081(vector);
                class_2680 upperState = this.method_37908().method_8320(upperPosition);
                class_2680 lowerState = this.method_37908().method_8320(lowerPosition);
                if (this.isBreakable(upperState) && (upperState.method_26218((class_1922)this.method_37908(), upperPosition).equals(class_259.method_1077()) || !upperState.method_26220((class_1922)this.method_37908(), upperPosition).method_1110()) && (this.getDungeon() == null || this.getDungeon().roomBounds().method_1006(upperPosition.method_46558()))) {
                    this.method_37908().method_8651(upperPosition, true, (class_1297)this);
                    this.method_6104(class_1268.field_5808);
                    continue;
                }
                if (!this.isBreakable(lowerState) || !lowerState.method_26218((class_1922)this.method_37908(), lowerPosition).equals(class_259.method_1077()) && lowerState.method_26220((class_1922)this.method_37908(), lowerPosition).method_1110() || this.getDungeon() != null && !this.getDungeon().roomBounds().method_1006(lowerPosition.method_46558())) continue;
                this.method_37908().method_8651(lowerPosition, true, (class_1297)this);
                this.method_6104(class_1268.field_5808);
            }
        }
    }

    private boolean isBreakable(class_2680 blockState) {
        return !blockState.method_26215() && !blockState.method_26164(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE) && blockState.method_26204().method_36555() >= 0.0f && blockState.method_26204().method_36555() < 100.0f;
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds((class_1308)this);
        AetherBossMob.super.evaporate(this, (class_2338)minMax.getLeft(), (class_2338)minMax.getRight(), blockState -> !blockState.method_26164(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE));
    }

    public void method_5958() {
        super.method_5958();
        this.bossFight.method_5408(this.method_6032() / this.method_6063());
        this.trackDungeon();
    }

    @Override
    protected boolean teleportAroundTarget(class_1297 target) {
        class_241 targetVec = new class_241(this.method_59922().method_43057() - 0.5f, this.method_59922().method_43057() - 0.5f).method_35581();
        double x = target.method_23317() + (double)(targetVec.field_1343 * 7.0f);
        double y = target.method_23318();
        double z = target.method_23321() + (double)(targetVec.field_1342 * 7.0f);
        if (this.getDungeon() != null) {
            class_238 room = this.getDungeon().roomBounds();
            x = class_3532.method_15350((double)x, (double)(room.field_1323 + 1.0), (double)(room.field_1320 - 1.0));
            y = class_3532.method_15350((double)y, (double)(room.field_1322 + 1.0), (double)(room.field_1325 - 1.0));
            z = class_3532.method_15350((double)z, (double)(room.field_1321 + 1.0), (double)(room.field_1324 - 1.0));
        }
        return this.teleport(x, y, z);
    }

    protected void teleportUnstuck(class_1297 target) {
        this.teleport(target.method_23317(), target.method_23318(), target.method_23321());
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808 && !this.isBossFight() && !this.method_37908().method_8608()) {
            if (!this.isReady()) {
                this.method_5951((class_1297)player, 180.0f, 180.0f);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (this.getConversingPlayer() == null) {
                        this.method_5783(this.getInteractSound(), 1.0f, this.method_6017());
                        PacketDistributor.sendToPlayer(serverPlayer, new QueenDialoguePacket(this.method_5628()), new class_8710[0]);
                        this.setConversingPlayer((class_1657)serverPlayer);
                    }
                }
            } else {
                this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.ready"), true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void openDialogueScreen() {
        class_310.method_1551().method_1507((class_437)new ValkyrieQueenDialogueScreen(this));
    }

    @Override
    public void handleNpcInteraction(class_1657 player, byte interactionID) {
        block0 : switch (interactionID) {
            case 0: {
                this.chat(player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.answer"), true);
                break;
            }
            case 1: {
                if (this.method_37908().method_8407() == class_1267.field_5801) {
                    this.chat(player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.peaceful"), true);
                    break;
                }
                if (player.method_31548().method_18861((class_1792)AetherItems.VICTORY_MEDAL.get()) >= 10) {
                    this.readyUp();
                    int count = 10;
                    for (class_1799 item : player.field_7498.method_7602()) {
                        if (item.method_31574((class_1792)AetherItems.VICTORY_MEDAL.get())) {
                            if (item.method_7947() > count) {
                                item.method_7934(count);
                                break block0;
                            }
                            count -= item.method_7947();
                            item.method_7939(0);
                        }
                        if (count > 0) continue;
                        break block0;
                    }
                    break;
                }
                this.chat(player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.no_medals"), true);
                break;
            }
            case 2: {
                this.chat(player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.deny_fight"), true);
                break;
            }
            default: {
                this.chat(player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.goodbye"), true);
            }
        }
        this.setConversingPlayer(null);
    }

    public void readyUp() {
        class_5250 message = class_2561.method_43471((String)"gui.aether.queen.dialog.begin");
        this.chatWithNearby((class_2561)message, true);
        this.setReady(true);
    }

    protected void chatWithNearby(class_2561 message, boolean sound) {
        class_238 room = this.dungeon == null ? this.method_5829().method_1014(16.0) : this.dungeon.roomBounds();
        this.method_37908().method_18464(NON_COMBAT, (class_1309)this, room).forEach(player -> this.chat((class_1657)player, message, sound));
    }

    @Override
    protected void chat(class_1657 player, class_2561 message, boolean sound) {
        player.method_43496((class_2561)class_2561.method_43470((String)"[").method_10852((class_2561)this.getBossName().method_27661().method_27692(class_124.field_1054)).method_27693("]: ").method_10852(message));
        this.method_5783(this.getInteractSound(), 1.0f, this.method_6017());
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        if (source.method_48789(class_8103.field_42242)) {
            return super.method_5643(source, amount);
        }
        if (this.isReady() && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (this.method_37908().method_8407() != class_1267.field_5801) {
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((class_1297)attacker)) {
                    if (super.method_5643(source, amount) && this.method_6032() > 0.0f) {
                        if (!this.method_37908().method_8608() && !this.isBossFight()) {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.fight"), false);
                            this.method_6033(this.method_6063());
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                            AetherEventDispatch.onBossFightStart((class_1297)this, this.getDungeon());
                        }
                        return true;
                    }
                } else if (!this.method_37908().method_8608() && attacker instanceof class_1657) {
                    class_1657 player = (class_1657)attacker;
                    this.displayTooFarMessage(player);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean method_6121(class_1297 entity) {
        class_3222 player;
        boolean result = super.method_6121(entity);
        if (entity instanceof class_3222 && (player = (class_3222)entity).method_6032() <= 0.0f) {
            this.chat((class_1657)player, (class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.playerdeath"), true);
        }
        return result;
    }

    public void reset() {
        this.setBossFight(false);
        this.method_5980(null);
        if (this.getDungeon() != null) {
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((class_1297)this, this.getDungeon());
    }

    public void method_6078(class_1282 source) {
        if (!this.method_37908().field_9236) {
            this.bossFight.method_5408(this.method_6032() / this.method_6063());
            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.queen.dialog.defeated"), false);
            this.spawnExplosionParticles();
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.method_6078(source);
    }

    public void tearDownRoom() {
        for (class_2338 pos : class_2338.method_10094((int)((int)this.dungeonBounds.field_1323), (int)((int)this.dungeonBounds.field_1322), (int)((int)this.dungeonBounds.field_1321), (int)((int)this.dungeonBounds.field_1320), (int)((int)this.dungeonBounds.field_1325), (int)((int)this.dungeonBounds.field_1324))) {
            class_2680 state = this.method_37908().method_8320(pos);
            class_2680 newState = this.convertBlock(state);
            if (newState == null) continue;
            this.method_37908().method_8652(pos, newState, 3);
        }
    }

    public void method_5982() {
    }

    @Nullable
    public class_2680 convertBlock(class_2680 state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.method_26204(), blockState -> null).apply(state);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        PacketDistributor.sendToPlayer(player, new BossInfoPacket.Display(this.bossFight.method_5407(), this.method_5628()), new class_8710[0]);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((class_1657)player)) {
            this.bossFight.method_14088(player);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        PacketDistributor.sendToPlayer(player, new BossInfoPacket.Remove(this.bossFight.method_5407(), this.method_5628()), new class_8710[0]);
        this.bossFight.method_14089(player);
        AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14088(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14089(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isReady() {
        return (Boolean)this.method_5841().method_12789(DATA_IS_READY);
    }

    public void setReady(boolean ready) {
        this.method_5841().method_12778(DATA_IS_READY, (Object)ready);
    }

    public class_2561 getBossName() {
        return (class_2561)this.method_5841().method_12789(DATA_BOSS_NAME);
    }

    public void setBossName(class_2561 component) {
        this.method_5841().method_12778(DATA_BOSS_NAME, (Object)component);
        this.bossFight.method_5413(component);
    }

    @Nullable
    public BossRoomTracker<ValkyrieQueen> getDungeon() {
        return this.dungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<ValkyrieQueen> dungeon) {
        this.dungeon = dungeon;
        if (this.dungeonBounds == null) {
            this.dungeonBounds = dungeon.roomBounds();
        }
    }

    public boolean isBossFight() {
        return this.bossFight.method_14093();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.method_14091(isFighting);
    }

    @Override
    @Nullable
    public class_2960 getBossBarTexture() {
        return class_2960.method_60655((String)"aether", (String)"boss_bar/valkyrie_queen");
    }

    @Override
    @Nullable
    public class_2960 getBossBarBackgroundTexture() {
        return class_2960.method_60655((String)"aether", (String)"boss_bar/valkyrie_queen_background");
    }

    @Override
    @Nullable
    public class_5195 getBossMusic() {
        return VALKYRIE_QUEEN_MUSIC;
    }

    public void setDungeonBounds(@Nullable class_238 dungeonBounds) {
        this.dungeonBounds = dungeonBounds;
    }

    @Override
    @Nullable
    public class_1657 getConversingPlayer() {
        return this.conversingPlayer;
    }

    @Override
    public void setConversingPlayer(@Nullable class_1657 player) {
        this.conversingPlayer = player;
    }

    public int getDeathScore() {
        return this.field_6232;
    }

    public void method_5665(@Nullable class_2561 pName) {
        super.method_5665(pName);
        this.setBossName(pName);
    }

    protected class_3414 getInteractSound() {
        return AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_INTERACT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_HURT.get();
    }

    protected class_3414 method_6002() {
        return AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_DEATH.get();
    }

    protected boolean method_29920() {
        return this.field_6282;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.addBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        if (this.dungeonBounds != null) {
            tag.method_10549("DungeonBoundsMinX", this.dungeonBounds.field_1323);
            tag.method_10549("DungeonBoundsMinY", this.dungeonBounds.field_1322);
            tag.method_10549("DungeonBoundsMinZ", this.dungeonBounds.field_1321);
            tag.method_10549("DungeonBoundsMaxX", this.dungeonBounds.field_1320);
            tag.method_10549("DungeonBoundsMaxY", this.dungeonBounds.field_1325);
            tag.method_10549("DungeonBoundsMaxZ", this.dungeonBounds.field_1324);
        }
        tag.method_10556("Ready", this.isReady());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.readBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        if (tag.method_10545("DungeonBoundsMinX")) {
            double minX = tag.method_10574("DungeonBoundsMinX");
            double minY = tag.method_10574("DungeonBoundsMinY");
            double minZ = tag.method_10574("DungeonBoundsMinZ");
            double maxX = tag.method_10574("DungeonBoundsMaxX");
            double maxY = tag.method_10574("DungeonBoundsMaxY");
            double maxZ = tag.method_10574("DungeonBoundsMaxZ");
            this.dungeonBounds = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (tag.method_10545("Ready")) {
            this.setReady(tag.method_10577("Ready"));
        }
    }

    @Override
    public void writeSpawnData(class_9129 buffer) {
        class_2487 tag = new class_2487();
        this.addBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        buffer.method_10794((class_2520)tag);
    }

    @Override
    public void readSpawnData(class_9129 additionalData) {
        class_2487 tag = additionalData.method_10798();
        if (tag != null) {
            this.readBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        }
    }

    public static class GetUnstuckGoal
    extends class_1352 {
        private final ValkyrieQueen valkyrie;
        protected int stuckTimer;

        public GetUnstuckGoal(ValkyrieQueen valkyrie) {
            this.valkyrie = valkyrie;
        }

        public boolean method_6264() {
            class_1309 target = this.valkyrie.method_5968();
            if (target == null) {
                return false;
            }
            if (target.method_23318() > this.valkyrie.method_23318()) {
                if (this.stuckTimer++ >= 75) {
                    this.stuckTimer = 0;
                    return true;
                }
            } else {
                this.stuckTimer = 0;
            }
            return false;
        }

        public void method_6269() {
            if (this.valkyrie.method_5968() != null) {
                this.valkyrie.teleportUnstuck((class_1297)this.valkyrie.method_5968());
            }
        }
    }

    public static class ThunderCrystalAttackGoal
    extends class_1352 {
        private final class_1308 mob;
        private final int attackInterval;
        private final float attackRadius;
        private int attackTime = 0;

        public ThunderCrystalAttackGoal(class_1308 mob, int attackInterval, float attackRadius) {
            this.mob = mob;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
        }

        public boolean method_6264() {
            class_1309 target = this.mob.method_5968();
            if (target != null && target.method_5805()) {
                return this.mob.method_37908().method_8407() != class_1267.field_5801;
            }
            return false;
        }

        public void method_6268() {
            double distance;
            if (this.mob.method_5968() != null && (distance = (double)this.mob.method_5739((class_1297)this.mob.method_5968())) < (double)this.attackRadius && ++this.attackTime >= this.attackInterval) {
                ThunderCrystal thunderCrystal = new ThunderCrystal(AetherEntityTypes.THUNDER_CRYSTAL.get(), this.mob.method_37908(), (class_1297)this.mob, (class_1297)this.mob.method_5968());
                this.mob.method_37908().method_8649((class_1297)thunderCrystal);
                this.attackTime = this.mob.method_59922().method_43048(40);
            }
        }

        public boolean method_38846() {
            return true;
        }
    }
}

